
<!DOCTYPE html>

<html>
    <head>
    <meta http-Equiv="Cache-Control" Content="no-cache">
    <meta http-Equiv="Pragma" Content="no-cache">
    <meta http-Equiv="Expires" Content="0">

        <title>
            Maps
        </title>
        <meta content="initial-scale=1.0, user-scalable=no" name="viewport">
        <meta charset="utf-8">
        <style>
html,body {
height:100%;
background-color:#F9F8F5;
color:#666;
font-family:Calibri, Arial;
margin:10px;
padding:0;
}

.gmap-popup {
  max-width:204px;
  max-height:110px;
}

.map-marker {
-webkit-filter:drop-shadow(2px 2px 2px #777);
}

#map-canvas {
-webkit-box-shadow:0 0 15px 0 rgba(25,50,50,1);
-moz-box-shadow:0 0 15px 0 rgba(25,50,50,1);
box-shadow:0 0 15px 0 rgba(25,50,50,1);
margin:15px 0 20px;
}

.control-label {
    float: left;
    padding:15px 0px 0px 0px;
    margin-right:50px;
    text-align: right;
    width: 160px;
    font-family:"Segoe UI", Helvetica, Verdana;
    font-size: 16px;
}
input[type="text"], input[type="textbox"] 
{
    background: none repeat scroll 0 0 #FCFCFC;
    border: 1px solid #A6A6A6;
    border-radius: 2px 2px 2px 2px;
    color: #6C6C6C;
    height: 35px;
    margin-top: 10px;
    outline: medium none;
    padding-left: 10px;
    width: 230px;
}
input[type="text"]:focus, input[type="textbox"]:focus {
    background: none repeat scroll 0 0 white;
    border-color: #7DC9E2;
    box-shadow: 0 0 2px rgba(0, 0, 0, 0.3) inset;
    color: #A6A6A6;
 content:"";
}

input[type="button"]
{
    border: 1px solid #A6A6A6;
    border-radius: 2px 2px 2px 2px;
    height: 40px;
    margin-top: 10px;
    outline: medium none;
    padding-left: 10px;
}

.group{margin-top:10px;}


h1 { margin: 0px }


        </style>
        <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&amp;sensor=true">
        </script>
        <script src="http://google-maps-utility-library-v3.googlecode.com/svn/trunk/markerclusterer/src/markerclusterer.js">
        </script>
        <script>
            var map;
            var geocoder;
            var mc;

function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}


            function codeAddress(address) {
                geocoder.geocode({
                    'address': address
                }, function(results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        var location = results[0].geometry.location;
                        var viewport = results[0].geometry.viewport;
                        map.setCenter(location);
                        map.fitBounds(viewport);

                        var marker = new google.maps.Marker({
                            position: results[0].geometry.location,
                            map: map,
                            animation: google.maps.Animation.DROP,
                            icon: 'http://maps.google.com/mapfiles/ms/icons/orange-dot.png'
                        });
                        var infowindow = new google.maps.InfoWindow({
                            content: '<div style="min-width: 200px;" ><p>' + address + '</p><br/></div>'
                        });
                        infowindow.open(map, marker);
                        map.panTo(location);

                    } else {
                        alert("Locating location failed: " + status);
                    }
                });
            }



            function initialize() {
                var mapOptions = {
                    zoom: 14
                };
                map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
                geocoder = new google.maps.Geocoder();

                codeAddress(decodeURI((getUrlVars()["address"]).replace(/(\r\n|\n|\r)/gm,"")));

                // Try HTML5 geolocation
                if (navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition(function(position) {
                        var pos = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);

                        var marker = new google.maps.Marker({
                            position: pos,
                            map: map,
                            animation: google.maps.Animation.DROP,
                            icon: 'http://i.imgur.com/OgO6MU0.gif',
                            optimized: false
                        });
                        var infowindow = new google.maps.InfoWindow({
                            content: 'My Location'
                        });
                        //infowindow.open(map,marker);
                    }, function() {
                        handleNoGeolocation(true);
                    });
                } else {
                    // Browser doesn't support Geolocation
                    handleNoGeolocation(false);
                }
            }


            function handleNoGeolocation(errorFlag) {
                var content = "";
                if (errorFlag) {
                    content = 'Error: The Geolocation service failed.';
                } else {
                    content = 'Error: Your browser doesn\'t support geolocation.';
                }

                var options = {
                    map: map,
                    position: new google.maps.LatLng(60, 105),
                    content: content
                };

                var infowindow = new google.maps.InfoWindow(options);
                map.setCenter(options.position);
            }

            google.maps.event.addDomListener(window, 'load', initialize);
        </script>
    </head>
    <body>
        <div style="text-align:center;">
            <input id="address" type="textbox" placeholder="Enter an address">
            <input onclick="codeAddress(document.getElementById('address').value)" type="button" value="Geocode">
            <div id="map-canvas" style="width: 100%; height: 600px; align: center;">
            </div>
    </body>

</html>